#!/usr/bin/env python
# Show Only Current Tasks

# Copyright 2006 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 061113 - first version of this script

# calculated completion date 
# in last 7 days or next 14 days  -- This part is implemented
#
# OR
# if actual end date or percent complete have been entered
#	include all past tasks that have not been completed
#
# OR
# ancestor of included task
#


def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

def ShowOnlyCurrentTasks(self):
    """
    Show all current tasks; hide all non-current tasks
    """

    # define time interval for current tasks
    prior_days = 7
    future_days = 14

    # set local pointers to tables
    rid = self.ReportID  # current report
    drep = Data.Database['Report']
    drow = Data.Database['ReportRow']
    drt = Data.Database['ReportType']
    dt = Data.Database['Task']
    da = Data.Database['Assignment']
    dres = Data.Database['Resource']
    rr = drep[rid]

    # make sure report has report type
    if not rr.has_key('ReportTypeID') or not drt.has_key(rr['ReportTypeID']): 
        if debug: print "ReportType key not found"
        hint("Error: Can't find type of this report.")
        return
    rtid = rr['ReportTypeID']

    # is this a task report
    rt = drt[rtid] # pointer to report type record
    ta = rt.get('TableA')
    tb = rt.get('TableB')
    if not (ta == 'Task' or tb == 'Task'):
#    if (ta != 'Task'):
        hint('Use script only with Task reports.')
        return

    # get begin and end display dates
    today = Data.TodayDate()
    past = Data.DateToString(today - prior_days)
    future = Data.DateToString(today + future_days)

    # find all visible rows
    rows = Data.GetRowList(self.ReportID)  # all visible rows in display order
    # get row ids for all task rows
    rids = [ x for x in rows if drow[x].get('TableName') == 'Task' ]

    # get task ids of all current tasks 
    current_tasks = { }
    for rowid in rids:
        # get task id
        tid = drow[rowid].get("TableID")
        if not tid or not dt.has_key(tid): continue  # silently skip invalid rows

        # look up calculated end date
        calc_end = dt[tid].get('CalculatedEndDate')
        calc_start = dt[tid].get('CalculatedStartDate')

        # identify current tasks and parents of current tasks
        if calc_end and calc_start and past < calc_end and calc_start <= future:
            current_tasks[tid] = None
            parent_id = dt[tid].get('TaskID')
            while parent_id and not parent_id in current_tasks:
                current_tasks[tid] = None
                parent_id = dt[tid].get('TaskID')                

    for rowid in rids:
        # get task id
        tid = drow[rowid].get("TableID")
        if not tid or not dt.has_key(tid): continue  # silently skip invalid rows

        current = (tid in current_tasks)
        change = { 'Table': 'ReportRow', 'ID': rowid, 'Hidden': not current }
        Data.Update(change)

    Data.SetUndo("Show Only Current Tasks")

ShowOnlyCurrentTasks(self)
